/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.modifier.TagModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.HasModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.RequirementsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public class ModifierRequirementsModule
implements ValidateModifierHook,
ModifierModule,
RequirementsModifierHook {
    public static final RecordLoadable<ModifierRequirementsModule> LOADER = RecordLoadable.create((RecordField)ToolContextPredicate.LOADER.requiredField("requirement", m -> m.requirement), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", m -> m.level), (RecordField)StringLoadable.DEFAULT.requiredField("translation_key", m -> m.translationKey), (RecordField)ModifierEntry.LOADABLE.list(0).defaultField("display_modifiers", List.of(), m -> m.display), ModifierRequirementsModule::new);
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.VALIDATE, TinkerHooks.REQUIREMENTS);
    private final IJsonPredicate<IToolContext> requirement;
    private final IntRange level;
    private final String translationKey;
    private final List<ModifierEntry> display;
    private final Component errorMessage;

    public ModifierRequirementsModule(IJsonPredicate<IToolContext> requirement, IntRange level, String translationKey, List<ModifierEntry> display) {
        this.requirement = requirement;
        this.level = level;
        this.translationKey = translationKey;
        this.display = display;
        this.errorMessage = Component.m_237115_((String)translationKey);
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        if (this.level.test(modifier.getLevel()) && !this.requirement.matches((Object)tool)) {
            return this.errorMessage;
        }
        return null;
    }

    @Override
    @Nullable
    public Component requirementsError(ModifierEntry entry) {
        return this.level.test(entry.getLevel()) ? this.errorMessage : null;
    }

    @Override
    public List<ModifierEntry> displayModifiers(ModifierEntry entry) {
        return this.level.test(entry.getLevel()) ? this.display : List.of();
    }

    public RecordLoadable<ModifierRequirementsModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<IJsonPredicate<IToolContext>> requirements = ImmutableList.builder();
        private final ImmutableList.Builder<ModifierEntry> displayModifiers = ImmutableList.builder();
        private int minLevel = 1;
        private int maxLevel = ModifierEntry.VALID_LEVEL.max();
        private String translationKey;

        private Builder() {
        }

        public Builder modifierKey(ModifierId id) {
            this.translationKey = Util.makeTranslationKey("modifier", id) + ".requirements";
            return this;
        }

        public Builder modifierKey(LazyModifier id) {
            this.translationKey = Util.makeTranslationKey("modifier", id.getId()) + ".requirements";
            return this;
        }

        @CanIgnoreReturnValue
        public Builder displayModifier(ModifierId id, int level) {
            this.displayModifiers.add((Object)new ModifierEntry(id, level));
            return this;
        }

        public Builder requirement(IJsonPredicate<IToolContext> requirement) {
            this.requirements.add(requirement);
            return this;
        }

        public Builder requireUpgrade(ModifierId id, int level) {
            this.displayModifier(id, level);
            this.requirements.add((Object)HasModifierPredicate.hasUpgrade(id, level));
            return this;
        }

        public Builder requireModifier(ModifierId id, int level) {
            this.displayModifier(id, level);
            this.requirements.add((Object)HasModifierPredicate.hasModifier(id, level));
            return this;
        }

        public Builder requireUpgrade(TagKey<Modifier> tag, int level) {
            this.requirements.add((Object)HasModifierPredicate.hasUpgrade(new TagModifierPredicate(tag), level));
            return this;
        }

        public Builder requireModifier(TagKey<Modifier> tag, int level) {
            this.requirements.add((Object)HasModifierPredicate.hasUpgrade(new TagModifierPredicate(tag), level));
            return this;
        }

        public ModifierRequirementsModule build() {
            if (this.translationKey == null) {
                throw new IllegalStateException("Must set translation key");
            }
            ImmutableList predicates = this.requirements.build();
            if (predicates.isEmpty()) {
                throw new IllegalStateException("Must have at least one requirement");
            }
            IntRange range = ModifierEntry.VALID_LEVEL.range(this.minLevel, this.maxLevel);
            ImmutableList display = this.displayModifiers.build();
            if (predicates.size() == 1) {
                return new ModifierRequirementsModule((IJsonPredicate<IToolContext>)((IJsonPredicate)predicates.get(0)), range, this.translationKey, (List<ModifierEntry>)display);
            }
            return new ModifierRequirementsModule((IJsonPredicate<IToolContext>)ToolContextPredicate.LOADER.and((List)predicates), range, this.translationKey, (List<ModifierEntry>)display);
        }

        public Builder minLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        public Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }
    }
}

