/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.build;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.EnchantmentModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.IntLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface EnchantmentModule
extends ModifierModule,
IntLevelModule,
ModifierModuleCondition.ConditionalModifierModule {
    public static final LoadableField<Enchantment, EnchantmentModule> ENCHANTMENT = Loadables.ENCHANTMENT.requiredField("name", EnchantmentModule::enchantment);
    public static final LoadableField<IJsonPredicate<BlockState>, EnchantmentModule> BLOCK = BlockPredicate.LOADER.defaultField("block", EnchantmentModule::block);
    public static final LoadableField<IJsonPredicate<LivingEntity>, EnchantmentModule> HOLDER = LivingEntityPredicate.LOADER.defaultField("holder", EnchantmentModule::holder);

    public Enchantment enchantment();

    default public IJsonPredicate<BlockState> block() {
        return BlockPredicate.ANY;
    }

    default public IJsonPredicate<LivingEntity> holder() {
        return LivingEntityPredicate.ANY;
    }

    public static Builder builder(Enchantment enchantment) {
        return new Builder(enchantment);
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final Enchantment enchantment;
        private int level = 1;
        private IJsonPredicate<BlockState> block = BlockPredicate.ANY;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;

        public Constant constant() {
            if (this.block != BlockPredicate.ANY || this.holder != LivingEntityPredicate.ANY) {
                throw new IllegalStateException("Cannot build a constant enchantment module with block or holder conditions");
            }
            return new Constant(this.enchantment, this.level, this.condition);
        }

        public MainHandHarvest mainHandHarvest(ResourceLocation key) {
            return new MainHandHarvest(this.enchantment, this.level, this.condition, key, this.block, this.holder);
        }

        public ArmorHarvest armorHarvest(EquipmentSlot ... slots) {
            if (slots.length == 0) {
                throw new IllegalArgumentException("Must have at least 1 slot");
            }
            ImmutableSet set = ImmutableSet.copyOf((Object[])slots);
            if (set.contains(EquipmentSlot.MAINHAND)) {
                throw new IllegalArgumentException("Cannot create armor harvest for the main hand slot");
            }
            return new ArmorHarvest(this.enchantment, this.level, this.condition, (Set<EquipmentSlot>)set, this.block, this.holder);
        }

        public ArmorHarvest armorHarvest() {
            return this.armorHarvest(HarvestEnchantmentsModifierHook.APPLICABLE_SLOTS);
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder block(IJsonPredicate<BlockState> block) {
            this.block = block;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        private Builder(Enchantment enchantment) {
            this.enchantment = enchantment;
        }
    }

    public record ArmorHarvest(Enchantment enchantment, int level, ModifierModuleCondition condition, Set<EquipmentSlot> slots, IJsonPredicate<BlockState> block, IJsonPredicate<LivingEntity> holder) implements EnchantmentModule,
    HarvestEnchantmentsModifierHook
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.HARVEST_ENCHANTMENTS);
        public static final RecordLoadable<ArmorHarvest> LOADER = RecordLoadable.create((RecordField)ENCHANTMENT, IntLevelModule.FIELD, ModifierModuleCondition.FIELD, (RecordField)TinkerLoadables.EQUIPMENT_SLOT_SET.requiredField("slots", ArmorHarvest::slots), (RecordField)BLOCK, (RecordField)HOLDER, ArmorHarvest::new);

        @Override
        public void updateHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, EquipmentContext equipment, EquipmentSlot slot, Map<Enchantment, Integer> map) {
            if (this.slots.contains(slot) && this.condition.matches(tool, modifier) && this.block.matches((Object)context.getState()) && this.holder.matches((Object)context.getLiving())) {
                EnchantmentModifierHook.addEnchantment(map, this.enchantment, this.getLevel(modifier));
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public record MainHandHarvest(Enchantment enchantment, int level, ModifierModuleCondition condition, ResourceLocation conditionFlag, IJsonPredicate<BlockState> block, IJsonPredicate<LivingEntity> holder) implements EnchantmentModule,
    EnchantmentModifierHook,
    BlockHarvestModifierHook
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.ENCHANTMENTS, TinkerHooks.BLOCK_HARVEST);
        public static final RecordLoadable<MainHandHarvest> LOADER = RecordLoadable.create((RecordField)ENCHANTMENT, IntLevelModule.FIELD, ModifierModuleCondition.FIELD, (RecordField)Loadables.RESOURCE_LOCATION.requiredField("condition_flag", MainHandHarvest::conditionFlag), (RecordField)BLOCK, (RecordField)HOLDER, MainHandHarvest::new);

        @Override
        public void startHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
            if (this.condition.matches(tool, modifier) && this.block.matches((Object)context.getState()) && this.holder.matches((Object)context.getLiving())) {
                tool.getPersistentData().putBoolean(this.conditionFlag, true);
            }
            BlockHarvestModifierHook.super.startHarvest(tool, modifier, context);
        }

        @Override
        public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, boolean didHarvest) {
            tool.getPersistentData().remove(this.conditionFlag);
        }

        @Override
        public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            if (enchantment == this.enchantment() && tool.getPersistentData().getBoolean(this.conditionFlag)) {
                level += this.getLevel(modifier);
            }
            return level;
        }

        @Override
        public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
            if (tool.getPersistentData().getBoolean(this.conditionFlag)) {
                EnchantmentModifierHook.addEnchantment(map, this.enchantment(), this.getLevel(modifier));
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public record Constant(Enchantment enchantment, int level, ModifierModuleCondition condition) implements EnchantmentModule,
    EnchantmentModifierHook
    {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.ENCHANTMENTS);
        public static final RecordLoadable<Constant> LOADER = RecordLoadable.create((RecordField)ENCHANTMENT, IntLevelModule.FIELD, ModifierModuleCondition.FIELD, Constant::new);

        public Constant(Enchantment enchantment, int level) {
            this(enchantment, level, ModifierModuleCondition.ANY);
        }

        @Override
        public int updateEnchantmentLevel(IToolStackView tool, ModifierEntry modifier, Enchantment enchantment, int level) {
            if (enchantment == this.enchantment() && this.condition().matches(tool, modifier)) {
                level += this.getLevel(modifier);
            }
            return level;
        }

        @Override
        public void updateEnchantments(IToolStackView tool, ModifierEntry modifier, Map<Enchantment, Integer> map) {
            if (this.condition().matches(tool, modifier)) {
                EnchantmentModifierHook.addEnchantment(map, this.enchantment(), this.getLevel(modifier));
            }
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }
}

