/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public record ModifierModuleCondition(IJsonPredicate<IToolContext> tool, IntRange modifierLevel) {
    public static final ModifierModuleCondition ANY = new ModifierModuleCondition(ToolContextPredicate.ANY, ModifierEntry.VALID_LEVEL);
    public static final RecordLoadable<ModifierModuleCondition> LOADABLE = RecordLoadable.create((RecordField)ToolContextPredicate.LOADER.defaultField("tool", ModifierModuleCondition::tool), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", ModifierModuleCondition::modifierLevel), ModifierModuleCondition::new);
    public static final LoadableField<ModifierModuleCondition, ConditionalModifierModule> FIELD = LOADABLE.directField(ConditionalModifierModule::condition);

    public ModifierModuleCondition with(IJsonPredicate<IToolContext> tool) {
        return new ModifierModuleCondition(tool, this.modifierLevel);
    }

    public ModifierModuleCondition with(IntRange modifierLevel) {
        return new ModifierModuleCondition(this.tool, modifierLevel);
    }

    public boolean matches(IToolContext tool, ModifierEntry modifier) {
        return this.modifierLevel.test(modifier.getLevel()) && this.tool.matches((Object)tool);
    }

    public void serializeInto(JsonObject parent) {
        if (this.tool != ToolContextPredicate.ANY) {
            parent.add("tool", ToolContextPredicate.LOADER.serialize(this.tool));
        }
        ModifierEntry.VALID_LEVEL.serializeInto(parent, "modifier_level", this.modifierLevel);
    }

    public static ModifierModuleCondition deserializeFrom(JsonObject parent) {
        IJsonPredicate tool = (IJsonPredicate)ToolContextPredicate.LOADER.getOrDefault(parent, "tool");
        IntRange modifierLevel = ModifierEntry.VALID_LEVEL.getOrDefault(parent, "modifier_level");
        return new ModifierModuleCondition((IJsonPredicate<IToolContext>)tool, modifierLevel);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        ToolContextPredicate.LOADER.encode(buffer, this.tool);
        this.modifierLevel.toNetwork(buffer);
    }

    public static ModifierModuleCondition fromNetwork(FriendlyByteBuf buffer) {
        IJsonPredicate tool = (IJsonPredicate)ToolContextPredicate.LOADER.decode(buffer);
        IntRange modifierLevel = IntRange.fromNetwork(buffer);
        return new ModifierModuleCondition((IJsonPredicate<IToolContext>)tool, modifierLevel);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected ModifierModuleCondition condition = ANY;

        private T setCondition(ModifierModuleCondition condition) {
            this.condition = condition;
            return (T)this;
        }

        public T tool(IJsonPredicate<IToolContext> tool) {
            return this.setCondition(this.condition.with(tool));
        }

        public T toolItem(IJsonPredicate<Item> tool) {
            return this.tool(ToolContextPredicate.fallback(tool));
        }

        private T setLevels(IntRange range) {
            return this.setCondition(this.condition.with(range));
        }

        public T levelRange(int min, int max) {
            return this.setLevels(ModifierEntry.VALID_LEVEL.range(min, max));
        }

        public T minLevel(int min) {
            return this.setLevels(ModifierEntry.VALID_LEVEL.min(min));
        }

        public T maxLevel(int max) {
            return this.setLevels(ModifierEntry.VALID_LEVEL.max(max));
        }

        public T exactLevel(int value) {
            return this.setLevels(ModifierEntry.VALID_LEVEL.exactly(value));
        }
    }

    public static interface ConditionalModifierModule {
        public ModifierModuleCondition condition();
    }
}

