/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.IncrementalModifierEntry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public abstract class DurabilityShieldModifier
extends Modifier
implements ToolDamageModifierHook,
ValidateModifierHook,
ModifierRemovalHook,
DurabilityDisplayModifierHook {
    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_DAMAGE, TinkerHooks.VALIDATE, TinkerHooks.REMOVE, TinkerHooks.DURABILITY_DISPLAY);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry) {
        return IncrementalModifierEntry.addAmountToName(this.getDisplayName(entry.getLevel()), this.getShield(tool), this.getShieldCapacity(tool, entry.getLevel()));
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        int cap = this.getShieldCapacity(tool, modifier.getLevel());
        if (this.getShield(tool) > cap) {
            this.setShield(tool.getPersistentData(), cap);
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(this.getShieldKey());
        return null;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        int shield = this.getShield(tool);
        int level = modifier.getLevel();
        if (shield > 0) {
            if (shield >= amount) {
                this.setShield(tool, level, shield - amount);
                return 0;
            }
            amount -= shield;
            this.setShield(tool, level, 0);
        }
        return amount;
    }

    @Override
    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifier) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            return DurabilityDisplayModifierHook.getWidthFor(shield, this.getShieldCapacity(tool, modifier.getLevel()));
        }
        return 0;
    }

    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    protected int getShield(IToolStackView tool) {
        return tool.getPersistentData().getInt(this.getShieldKey());
    }

    protected abstract int getShieldCapacity(IToolStackView var1, int var2);

    protected void setShield(ModDataNBT persistentData, int amount) {
        persistentData.putInt(this.getShieldKey(), Math.max(amount, 0));
    }

    protected void setShield(IToolStackView tool, int level, int amount) {
        this.setShield(tool.getPersistentData(), Math.min(amount, this.getShieldCapacity(tool, level)));
    }

    protected void addShield(IToolStackView tool, int level, int amount) {
        this.setShield(tool, level, amount + this.getShield(tool));
    }
}

