/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.interaction;

import java.util.Collection;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public interface EntityInteractionModifierHook {
    default public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
        return InteractionResult.PASS;
    }

    default public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
        return InteractionResult.PASS;
    }

    public static boolean leftClickEntity(ItemStack stack, Player player, Entity target) {
        ToolStack tool = ToolStack.from(stack);
        if (!player.m_36335_().m_41519_(stack.m_41720_())) {
            List<ModifierEntry> modifiers = tool.getModifierList();
            for (ModifierEntry entry : modifiers) {
                if (!entry.getHook(TinkerHooks.ENTITY_INTERACT).beforeEntityUse(tool, entry, player, target, InteractionHand.MAIN_HAND, InteractionSource.LEFT_CLICK).m_19077_()) continue;
                return true;
            }
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                for (ModifierEntry entry : modifiers) {
                    if (!entry.getHook(TinkerHooks.ENTITY_INTERACT).afterEntityUse(tool, entry, player, living, InteractionHand.MAIN_HAND, InteractionSource.LEFT_CLICK).m_19077_()) continue;
                    return true;
                }
            }
        }
        return ToolAttackUtil.attackEntity(tool, player, target);
    }

    public record FirstMerger(Collection<EntityInteractionModifierHook> modules) implements EntityInteractionModifierHook
    {
        @Override
        public InteractionResult beforeEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, Entity target, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (EntityInteractionModifierHook module : this.modules) {
                result = module.beforeEntityUse(tool, modifier, player, target, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }

        @Override
        public InteractionResult afterEntityUse(IToolStackView tool, ModifierEntry modifier, Player player, LivingEntity target, InteractionHand hand, InteractionSource source) {
            InteractionResult result = InteractionResult.PASS;
            for (EntityInteractionModifierHook module : this.modules) {
                result = module.afterEntityUse(tool, modifier, player, target, hand, source);
                if (!result.m_19077_()) continue;
                return result;
            }
            return result;
        }
    }
}

