/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.tool;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.predicate.FallbackPredicateRegistry;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.PredicateRegistry;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;

public interface ToolContextPredicate
extends IJsonPredicate<IToolContext> {
    public static final ToolContextPredicate ANY = ToolContextPredicate.simple(tool -> true);
    public static final FallbackPredicateRegistry<IToolContext, Item> LOADER = new FallbackPredicateRegistry("Tool Predicate", (IJsonPredicate)ANY, (PredicateRegistry)ItemPredicate.LOADER, IToolContext::getItem, "item");
    public static final ToolContextPredicate HAS_UPGRADES = ToolContextPredicate.simple(tool -> !tool.getUpgrades().isEmpty());

    default public IJsonPredicate<IToolContext> inverted() {
        return LOADER.invert((IJsonPredicate)this);
    }

    public static ToolContextPredicate simple(final Predicate<IToolContext> predicate) {
        return (ToolContextPredicate)GenericLoaderRegistry.SingletonLoader.singleton(loader -> new ToolContextPredicate(){
            final /* synthetic */ GenericLoaderRegistry.IGenericLoader val$loader;
            {
                this.val$loader = iGenericLoader;
            }

            public boolean matches(IToolContext tool) {
                return predicate.test(tool);
            }

            public GenericLoaderRegistry.IGenericLoader<? extends ToolContextPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<IToolContext> fallback(IJsonPredicate<Item> predicate) {
        return LOADER.fallback(predicate);
    }

    public static IJsonPredicate<IToolContext> set(Item ... items) {
        return LOADER.fallback(ItemPredicate.set((Item[])items));
    }

    public static IJsonPredicate<IToolContext> tag(TagKey<Item> tag) {
        return LOADER.fallback(ItemPredicate.tag(tag));
    }

    @SafeVarargs
    public static IJsonPredicate<IToolContext> and(IJsonPredicate<IToolContext> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<IToolContext> or(IJsonPredicate<IToolContext> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

