/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.loot;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.loot.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;

public class AddToolDataFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation ID = TConstruct.getResource("add_tool_data");
    public static final Serializer SERIALIZER = new Serializer();
    private final float damage;
    private final List<RandomMaterial> materials;

    protected AddToolDataFunction(LootItemCondition[] conditionsIn, float damage, List<RandomMaterial> materials) {
        super(conditionsIn);
        this.damage = damage;
        this.materials = materials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)TinkerTools.lootAddToolData.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            ToolStack tool = ToolStack.from(stack);
            if (tool.getDefinition().isMultipart() && !this.materials.isEmpty()) {
                MaterialNBT.Builder builder = MaterialNBT.builder();
                RandomSource random = context.m_230907_();
                for (RandomMaterial material : this.materials) {
                    builder.add(material.getMaterial(random));
                }
                tool.setMaterials(builder.build());
            } else {
                tool.rebuildStats();
            }
            if (this.damage > 0.0f) {
                tool.setDamage((int)(tool.getStats().get(ToolStats.DURABILITY).floatValue() * this.damage));
            }
        }
        return stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final ImmutableList.Builder<RandomMaterial> materials = ImmutableList.builder();
        private float damage = 0.0f;

        protected Builder() {
        }

        protected Builder getThis() {
            return this;
        }

        public void setDamage(float damage) {
            if (damage < 0.0f || damage > 1.0f) {
                throw new IllegalArgumentException("Damage must be between 0 and 1, given " + damage);
            }
            this.damage = damage;
        }

        public Builder addMaterial(RandomMaterial mat) {
            this.materials.add((Object)mat);
            return this;
        }

        public Builder addMaterial(MaterialId mat) {
            return this.addMaterial(RandomMaterial.fixed(mat));
        }

        public LootItemFunction m_7453_() {
            return new AddToolDataFunction(this.m_80699_(), this.damage, (List<RandomMaterial>)this.materials.build());
        }
    }

    private static class Serializer
    extends LootItemConditionalFunction.Serializer<AddToolDataFunction> {
        private Serializer() {
        }

        public void serialize(JsonObject json, AddToolDataFunction loot, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)loot, context);
            if (loot.damage > 0.0f) {
                json.addProperty("damage_percent", (Number)Float.valueOf(loot.damage));
            }
            if (!loot.materials.isEmpty()) {
                JsonArray array = new JsonArray();
                for (RandomMaterial material : loot.materials) {
                    array.add((JsonElement)material.serialize());
                }
                json.add("materials", (JsonElement)array);
            }
        }

        public AddToolDataFunction deserialize(JsonObject object, JsonDeserializationContext context, LootItemCondition[] conditions) {
            float damage = GsonHelper.m_13820_((JsonObject)object, (String)"damage_percent", (float)0.0f);
            if (damage < 0.0f || damage > 1.0f) {
                throw new JsonSyntaxException("damage_percent must be between 0 and 1, given " + damage);
            }
            List materials = Collections.emptyList();
            if (object.has("materials")) {
                materials = JsonHelper.parseList((JsonObject)object, (String)"materials", RandomMaterial::deserialize);
            }
            return new AddToolDataFunction(conditions, damage, materials);
        }
    }
}

