/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.FluidContainerModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.NormalModifierModel;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class FluidModifierModel
extends NormalModifierModel {
    private static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("dynamic_fluid_model");
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material largeTexture = (Material)largeGetter.apply("");
        Material smallFull = (Material)smallGetter.apply("_full");
        Material largeFull = (Material)largeGetter.apply("_full");
        if (smallTexture != null || largeTexture != null) {
            return new FluidModifierModel(smallTexture, largeTexture, smallFull, largeFull);
        }
        return null;
    };
    protected final Material[] fluidTextures;

    protected FluidModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, Material[] fluidTextures) {
        super(smallTexture, largeTexture);
        this.fluidTextures = fluidTextures;
    }

    public FluidModifierModel(@Nullable Material smallTexture, @Nullable Material largeTexture, @Nullable Material smallFull, @Nullable Material largeFull) {
        this(smallTexture, largeTexture, new Material[]{smallFull, largeFull});
    }

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        FluidStack fluid = entry.getHook(ToolFluidCapability.HOOK).getFluidInTank(tool, entry, 0);
        if (!fluid.isEmpty()) {
            return new FluidModifierCacheKey(entry.getModifier(), fluid.getFluid());
        }
        return entry.getId();
    }

    @Nullable
    protected Material getTemplate(ToolFluidCapability.FluidModifierHook tank, IToolStackView tool, ModifierEntry entry, FluidStack fluid, boolean isLarge) {
        return this.fluidTextures[isLarge ? 1 : 0];
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IToolStackView tool, ModifierEntry entry, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        Material template;
        ImmutableList quads = super.getQuads(tool, entry, spriteGetter, transforms, isLarge, startTintIndex, pixels);
        ToolFluidCapability.FluidModifierHook tank = entry.getHook(ToolFluidCapability.HOOK);
        FluidStack fluid = tank.getFluidInTank(tool, entry, 0);
        if (!fluid.isEmpty() && (template = this.getTemplate(tank, tool, entry, fluid, isLarge)) != null) {
            int color;
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            TextureAtlasSprite fluidSprite = spriteGetter.apply(new Material(InventoryMenu.f_39692_, attributes.getStillTexture(fluid)));
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)spriteGetter.apply(template));
            List fluidQuads = UnbakedGeometryHelper.bakeElements((List)unbaked, mat -> fluidSprite, (ModelState)new SimpleModelState(transforms.m_121096_(FluidContainerModel.FLUID_TRANSFORM), false), (ResourceLocation)BAKE_LOCATION);
            int luminosity = fluid.getFluid().getFluidType().getLightLevel(fluid);
            if (luminosity > 0) {
                QuadTransformers.settingEmissivity((int)luminosity).processInPlace(fluidQuads);
            }
            if ((color = attributes.getTintColor(fluid)) != -1) {
                ColoredBlockModel.applyColorQuadTransformer((int)color).processInPlace(fluidQuads);
            }
            quads = ImmutableList.copyOf((Collection)fluidQuads);
        }
        return quads;
    }

    private record FluidModifierCacheKey(Modifier modifier, Fluid fluid) {
    }
}

