/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.tools;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.BakedUniqueGuiModel;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolModel
implements IUnbakedGeometry<ToolModel> {
    public static final IGeometryLoader<ToolModel> LOADER = ToolModel::deserialize;
    public static final ItemColor COLOR_HANDLER = (stack, index) -> {
        ItemOverrides patt4276$temp;
        BakedModel itemModel;
        if (index >= 0 && (itemModel = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(stack.m_41720_())) != null && (patt4276$temp = itemModel.m_7343_()) instanceof MaterialOverrideHandler) {
            MaterialOverrideHandler overrides = (MaterialOverrideHandler)patt4276$temp;
            ToolStack tool = ToolStack.from(stack);
            int localIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            for (int i = modifiers.size() - 1; i >= 0; --i) {
                ModifierEntry entry = modifiers.get(i);
                IBakedModifierModel modifierModel = overrides.getModifierModel(entry.getModifier());
                if (modifierModel == null) continue;
                int modelIndexes = modifierModel.getTintIndexes();
                if (localIndex + modelIndexes > index) {
                    return modifierModel.getTint(tool, entry, index - localIndex);
                }
                localIndex += modelIndexes;
            }
        }
        return -1;
    };
    private List<ToolPart> toolParts;
    private final boolean isLarge;
    private final Vec2 offset;
    private final List<ResourceLocation> smallModifierRoots;
    private final List<ResourceLocation> largeModifierRoots;
    private final List<ModifierId> firstModifiers;
    private Map<ModifierId, IBakedModifierModel> modifierModels = Collections.emptyMap();

    public static void registerItemColors(ItemColors colors, Supplier<? extends IModifiable> item) {
        colors.m_92689_(COLOR_HANDLER, new ItemLike[]{item.get()});
    }

    public static ToolModel deserialize(JsonObject json, JsonDeserializationContext context) {
        List parts = Collections.emptyList();
        if (json.has("parts")) {
            parts = JsonHelper.parseList((JsonObject)json, (String)"parts", ToolPart::read);
        }
        boolean isLarge = GsonHelper.m_13855_((JsonObject)json, (String)"large", (boolean)false);
        Vec2 offset = Vec2.f_82462_;
        if (json.has("large_offset")) {
            offset = MaterialModel.getVec2(json, "large_offset");
        }
        List smallModifierRoots = Collections.emptyList();
        List largeModifierRoots = Collections.emptyList();
        if (json.has("modifier_roots")) {
            if (isLarge) {
                JsonObject modifierRoots = GsonHelper.m_13930_((JsonObject)json, (String)"modifier_roots");
                BiFunction<JsonElement, String, ResourceLocation> parser = (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string));
                smallModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"small", parser);
                largeModifierRoots = JsonHelper.parseList((JsonObject)modifierRoots, (String)"large", parser);
            } else {
                smallModifierRoots = JsonHelper.parseList((JsonObject)json, (String)"modifier_roots", (element, string) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)element, (String)string)));
            }
        }
        List firstModifiers = Collections.emptyList();
        if (json.has("first_modifiers")) {
            firstModifiers = JsonHelper.parseList((JsonObject)json, (String)"first_modifiers", (arg_0, arg_1) -> ModifierId.PARSER.convert(arg_0, arg_1));
        }
        return new ToolModel(parts, isLarge, offset, smallModifierRoots, largeModifierRoots, firstModifiers);
    }

    public ToolModel(List<ToolPart> parts, boolean isLarge, Vec2 offset, List<ResourceLocation> smallModifierRoots, List<ResourceLocation> largeModifierRoots, List<ModifierId> firstModifiers) {
        this.toolParts = parts;
        this.isLarge = isLarge;
        this.offset = offset;
        this.smallModifierRoots = smallModifierRoots;
        this.largeModifierRoots = largeModifierRoots;
        this.firstModifiers = firstModifiers;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet allTextures = Sets.newHashSet();
        if (this.toolParts.isEmpty()) {
            this.toolParts = owner.hasMaterial(ToolPart.DEFAULT.broken) ? ToolPart.DEFAULT_PARTS : ToolPart.NO_BROKEN_PARTS;
        }
        for (ToolPart part : this.toolParts) {
            if (part.hasMaterials()) {
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, false), null);
                if (part.hasBroken()) {
                    MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, false), null);
                }
                if (!this.isLarge) continue;
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(false, true), null);
                if (!part.hasBroken()) continue;
                MaterialModel.getMaterialTextures(allTextures, owner, part.getName(true, true), null);
                continue;
            }
            allTextures.add(owner.getMaterial(part.getName(false, false)));
            if (part.hasBroken()) {
                allTextures.add(owner.getMaterial(part.getName(true, false)));
            }
            if (!this.isLarge) continue;
            allTextures.add(owner.getMaterial(part.getName(false, true)));
            if (!part.hasBroken()) continue;
            allTextures.add(owner.getMaterial(part.getName(true, true)));
        }
        this.modifierModels = ModifierModelManager.getModelsForTool(this.smallModifierRoots, this.isLarge ? this.largeModifierRoots : Collections.emptyList(), allTextures);
        return allTextures;
    }

    private static void addModifierQuads(Function<Material, TextureAtlasSprite> spriteGetter, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, IToolStackView tool, Consumer<ImmutableList<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels, Transformation transforms, boolean isLarge) {
        if (!modifierModels.isEmpty()) {
            int modelIndex = 0;
            List<ModifierEntry> modifiers = tool.getUpgrades().getModifiers();
            if (!modifiers.isEmpty()) {
                int i;
                FirstModifier[] firsts = new FirstModifier[firstModifiers.size()];
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                for (i = modifiers.size() - 1; i >= 0; --i) {
                    IBakedModifierModel model;
                    ModifierEntry entry = modifiers.get(i);
                    ModifierId modifier = entry.getModifier().getId();
                    if (hidden.contains((Object)modifier) || (model = modifierModels.get((Object)modifier)) == null) continue;
                    int index = firstModifiers.indexOf((Object)modifier);
                    if (index == -1) {
                        quadConsumer.accept(model.getQuads(tool, entry, spriteGetter, transforms, isLarge, modelIndex, pixels));
                    } else {
                        firsts[index] = new FirstModifier(entry, model, modelIndex);
                    }
                    modelIndex += model.getTintIndexes();
                }
                for (i = firsts.length - 1; i >= 0; --i) {
                    FirstModifier first = firsts[i];
                    if (first == null) continue;
                    quadConsumer.accept(first.model.getQuads(tool, first.entry, spriteGetter, transforms, isLarge, first.modelIndex, pixels));
                }
            }
        }
    }

    private static List<BakedQuad> filterToGuiQuads(List<BakedQuad> quads) {
        return quads.stream().filter(quad -> quad.m_111306_() == Direction.SOUTH).toList();
    }

    private static IModelBuilder<?> makeModelBuilder(IGeometryBakingContext context, ItemOverrides overrides, TextureAtlasSprite particle) {
        return IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)overrides, (TextureAtlasSprite)particle, (RenderTypeGroup)MantleItemLayerModel.getDefaultRenderType((IGeometryBakingContext)context));
    }

    private static BakedModel bakeInternal(IGeometryBakingContext owner, Function<Material, TextureAtlasSprite> spriteGetter, @Nullable Transformation largeTransforms, List<ToolPart> parts, Map<ModifierId, IBakedModifierModel> modifierModels, List<ModifierId> firstModifiers, List<MaterialVariantId> materials, @Nullable IToolStackView tool, ItemOverrides overrides) {
        Transformation smallTransforms = Transformation.m_121093_();
        ReversedListBuilder guiQuads = new ReversedListBuilder();
        ReversedListBuilder fullQuads = new ReversedListBuilder();
        ItemLayerPixels pixels = new ItemLayerPixels();
        if (tool != null && !modifierModels.isEmpty()) {
            Consumer<ImmutableList<BakedQuad>> guiConsumer = quads -> guiQuads.add(ToolModel.filterToGuiQuads((List<BakedQuad>)quads));
            if (largeTransforms != null) {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, guiConsumer, null, smallTransforms, false);
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, arg_0 -> ((ReversedListBuilder)fullQuads).add(arg_0), pixels, largeTransforms, true);
            } else {
                ToolModel.addModifierQuads(spriteGetter, modifierModels, firstModifiers, tool, quads -> {
                    guiConsumer.accept((ImmutableList<BakedQuad>)quads);
                    fullQuads.add(quads);
                }, null, Transformation.m_121093_(), false);
            }
        }
        boolean isBroken = tool != null && tool.isBroken();
        TextureAtlasSprite particle = null;
        for (int i = parts.size() - 1; i >= 0; --i) {
            ToolPart part = parts.get(i);
            if (part.hasMaterials()) {
                int index = part.index();
                MaterialVariantId material = index < materials.size() ? materials.get(index) : null;
                MaterialRenderInfo.TintedSprite materialSprite = MaterialModel.getMaterialSprite(spriteGetter, owner.getMaterial(part.getName(isBroken, false)), material);
                particle = materialSprite.sprite();
                if (largeTransforms != null) {
                    guiQuads.add(List.of(MantleItemLayerModel.getQuadForGui((int)materialSprite.color(), (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)materialSprite.emissivity())));
                    fullQuads.add(MaterialModel.getQuadsForMaterial(spriteGetter, owner.getMaterial(part.getName(isBroken, true)), material, -1, largeTransforms, pixels));
                    continue;
                }
                ImmutableList quads2 = MantleItemLayerModel.getQuadsForSprite((int)materialSprite.color(), (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)0, (ItemLayerPixels)pixels);
                guiQuads.add(ToolModel.filterToGuiQuads((List<BakedQuad>)quads2));
                fullQuads.add((Object)quads2);
                continue;
            }
            particle = spriteGetter.apply(owner.getMaterial(part.getName(isBroken, false)));
            if (largeTransforms != null) {
                guiQuads.add(List.of(MantleItemLayerModel.getQuadForGui((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)0)));
                fullQuads.add((Object)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(owner.getMaterial(part.getName(isBroken, true))), (Transformation)largeTransforms, (int)0, (ItemLayerPixels)pixels));
                continue;
            }
            ImmutableList quads3 = MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)particle, (Transformation)smallTransforms, (int)0, (ItemLayerPixels)pixels);
            guiQuads.add(ToolModel.filterToGuiQuads((List<BakedQuad>)quads3));
            fullQuads.add((Object)quads3);
        }
        if (particle == null) {
            particle = spriteGetter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_()));
            TConstruct.LOG.error("Created tool model without a particle sprite, this means it somehow has no parts. This should not be possible");
        }
        IModelBuilder<?> guiModelBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        guiQuads.build(quads -> quads.forEach(arg_0 -> ((IModelBuilder)guiModelBuilder).addUnculledFace(arg_0)));
        IModelBuilder<?> fullModelBuilder = ToolModel.makeModelBuilder(owner, overrides, particle);
        fullQuads.build(quads -> quads.forEach(arg_0 -> ((IModelBuilder)fullModelBuilder).addUnculledFace(arg_0)));
        return new BakedUniqueGuiModel(fullModelBuilder.build(), guiModelBuilder.build());
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Transformation largeTransforms = this.isLarge ? new Transformation(new Vector3f((this.offset.f_82470_ - 8.0f) / 32.0f, (-this.offset.f_82471_ - 8.0f) / 32.0f, 0.0f), null, new Vector3f(2.0f, 2.0f, 1.0f), null) : null;
        overrides = new MaterialOverrideHandler(owner, this.toolParts, this.firstModifiers, largeTransforms, this.modifierModels, overrides);
        return ToolModel.bakeInternal(owner, spriteGetter, largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, Collections.emptyList(), null, overrides);
    }

    private record ToolPart(String name, int index, @Nullable String broken) {
        public static final ToolPart DEFAULT = new ToolPart("tool", -1, "broken");
        public static final List<ToolPart> DEFAULT_PARTS = List.of(DEFAULT);
        public static final List<ToolPart> NO_BROKEN_PARTS = List.of(new ToolPart(ToolPart.DEFAULT.name, -1, null));

        public boolean hasBroken() {
            return this.broken != null;
        }

        public boolean hasMaterials() {
            return this.index >= 0;
        }

        public String getName(boolean isBroken, boolean isLarge) {
            Object name = this.name;
            if (isBroken && this.broken != null) {
                name = this.broken;
            }
            if (isLarge) {
                name = "large_" + (String)name;
            }
            return name;
        }

        public static ToolPart read(JsonObject json) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            int index = GsonHelper.m_13824_((JsonObject)json, (String)"index", (int)-1);
            String broken = null;
            if (json.has("broken")) {
                broken = GsonHelper.m_13906_((JsonObject)json, (String)"broken");
            }
            return new ToolPart(name, index, broken);
        }
    }

    private record FirstModifier(ModifierEntry entry, IBakedModifierModel model, int modelIndex) {
    }

    public static final class MaterialOverrideHandler
    extends ItemOverrides {
        private static boolean ignoreNested = false;
        private final Cache<ToolCacheKey, BakedModel> cache = CacheBuilder.newBuilder().maximumSize((long)MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos().size() * 3L / 2L).build();
        private final IGeometryBakingContext owner;
        private final List<ToolPart> toolParts;
        private final List<ModifierId> firstModifiers;
        @Nullable
        private final Transformation largeTransforms;
        private final Map<ModifierId, IBakedModifierModel> modifierModels;
        private final ItemOverrides nested;

        private MaterialOverrideHandler(IGeometryBakingContext owner, List<ToolPart> toolParts, List<ModifierId> firstModifiers, @Nullable Transformation largeTransforms, Map<ModifierId, IBakedModifierModel> modifierModels, ItemOverrides nested) {
            this.owner = owner;
            this.toolParts = toolParts;
            this.firstModifiers = firstModifiers;
            this.largeTransforms = largeTransforms;
            this.modifierModels = modifierModels;
            this.nested = nested;
        }

        @Nullable
        public IBakedModifierModel getModifierModel(Modifier modifier) {
            return this.modifierModels.get((Object)modifier.getId());
        }

        private BakedModel bakeDynamic(List<MaterialVariantId> materials, IToolStackView tool) {
            return ToolModel.bakeInternal(this.owner, Material::m_119204_, this.largeTransforms, this.toolParts, this.modifierModels, this.firstModifiers, materials, tool, ItemOverrides.f_111734_);
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden;
            if (!ignoreNested && (overridden = this.nested.m_173464_(originalModel, stack, world, entity, seed)) != null && overridden != originalModel) {
                ignoreNested = true;
                BakedModel finalModel = overridden.m_7343_().m_173464_(overridden, stack, world, entity, seed);
                ignoreNested = false;
                return finalModel;
            }
            List<MaterialVariantId> materialIds = MaterialIdNBT.from(stack).getMaterials();
            ToolStack tool = ToolStack.from(stack);
            boolean broken = ToolDamageUtil.isBroken(stack);
            if (!broken && materialIds.isEmpty() && tool.getUpgrades().isEmpty()) {
                return originalModel;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ModifierEntry entry : tool.getUpgrades().getModifiers()) {
                Object cacheKey;
                IBakedModifierModel model;
                Set<ModifierId> hidden = ModifierSetWorktableRecipe.getModifierSet(tool.getPersistentData(), TConstruct.getResource("invisible_modifiers"));
                if (hidden.contains((Object)entry.getId()) || (model = this.getModifierModel(entry.getModifier())) == null || (cacheKey = model.getCacheKey(tool, entry)) == null) continue;
                builder.add(cacheKey);
            }
            try {
                return (BakedModel)this.cache.get((Object)new ToolCacheKey(materialIds, (List<Object>)builder.build(), broken), () -> this.bakeDynamic(materialIds, tool));
            }
            catch (ExecutionException e) {
                TConstruct.LOG.error("Failed to get tool model from cache", (Throwable)e);
                return originalModel;
            }
        }
    }

    private record ToolCacheKey(List<MaterialVariantId> materials, List<Object> modifierData, boolean broken) {
    }
}

