/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.item.ModifiableCrossbowItem;

public class TinkerItemProperties {
    private static final ResourceLocation AMMO_ID = TConstruct.getResource("ammo");
    private static final ItemPropertyFunction AMMO = (stack, level, entity, seed) -> {
        CompoundTag ammo;
        CompoundTag persistentData;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !(persistentData = nbt.m_128469_("tic_persistent")).m_128456_() && !(ammo = persistentData.m_128469_(ModifiableCrossbowItem.KEY_CROSSBOW_AMMO.toString())).m_128456_()) {
            return ammo.m_128461_("id").equals(Registry.f_122827_.m_7981_((Object)Items.f_42688_).toString()) ? 2.0f : 1.0f;
        }
        return 0.0f;
    };
    private static final ResourceLocation CHARGING_ID = TConstruct.getResource("charging");
    private static final ItemPropertyFunction CHARGING = (stack, level, holder, seed) -> {
        if (holder != null && holder.m_6117_() && holder.m_21211_() == stack) {
            UseAnim anim = stack.m_41780_();
            if (anim == UseAnim.BLOCK) {
                return 2.0f;
            }
            if (anim != UseAnim.EAT && anim != UseAnim.DRINK) {
                return 1.0f;
            }
        }
        return 0.0f;
    };
    private static final ResourceLocation CHARGE_ID = TConstruct.getResource("charge");
    private static final ItemPropertyFunction CHARGE = (stack, level, holder, seed) -> {
        if (holder == null || holder.m_21211_() != stack) {
            return 0.0f;
        }
        int drawtime = ModifierUtil.getPersistentInt(stack, GeneralInteractionModifierHook.KEY_DRAWTIME, -1);
        return drawtime == -1 ? 0.0f : (float)(stack.m_41779_() - holder.m_21212_()) / (float)drawtime;
    };

    public static void registerToolProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)CHARGING_ID, (ItemPropertyFunction)CHARGING);
        ItemProperties.register((Item)item, (ResourceLocation)CHARGE_ID, (ItemPropertyFunction)CHARGE);
    }

    public static void registerCrossbowProperties(Item item) {
        TinkerItemProperties.registerToolProperties(item);
        ItemProperties.register((Item)item, (ResourceLocation)AMMO_ID, (ItemPropertyFunction)AMMO);
    }
}

