/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.util;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;

public class DataGenSpriteReader
extends AbstractSpriteReader {
    private static final Logger log = LogManager.getLogger(DataGenSpriteReader.class);
    private final ExistingFileHelper existingFileHelper;
    private final String folder;

    @Override
    public boolean exists(ResourceLocation path) {
        return this.existingFileHelper.exists(path, PackType.CLIENT_RESOURCES, ".png", this.folder);
    }

    @Override
    public boolean metadataExists(ResourceLocation path) {
        return this.existingFileHelper.exists(path, PackType.CLIENT_RESOURCES, ".png.mcmeta", this.folder);
    }

    @Override
    public NativeImage read(ResourceLocation path) throws IOException {
        try {
            Resource resource = this.existingFileHelper.getResource(path, PackType.CLIENT_RESOURCES, ".png", this.folder);
            NativeImage image = NativeImage.m_85058_((InputStream)resource.m_215507_());
            this.openedImages.add(image);
            return image;
        }
        catch (IOException e) {
            log.error("Failed to read image at {}", (Object)path);
            throw e;
        }
    }

    @Override
    public JsonObject readMetadata(ResourceLocation path) throws IOException {
        try (BufferedReader reader = this.existingFileHelper.getResource(path, PackType.CLIENT_RESOURCES, ".png.mcmeta", this.folder).m_215508_();){
            JsonObject jsonObject = GsonHelper.m_13859_((Reader)reader);
            return jsonObject;
        }
    }

    public DataGenSpriteReader(ExistingFileHelper existingFileHelper, String folder) {
        this.existingFileHelper = existingFileHelper;
        this.folder = folder;
    }
}

