/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct;

import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.data.AdvancementsProvider;
import slimeknights.tconstruct.common.data.loot.GlobalLootModifiersProvider;
import slimeknights.tconstruct.common.data.loot.TConstructLootTableProvider;
import slimeknights.tconstruct.common.data.tags.BiomeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockEntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.BlockTagProvider;
import slimeknights.tconstruct.common.data.tags.EnchantmentTagProvider;
import slimeknights.tconstruct.common.data.tags.EntityTypeTagProvider;
import slimeknights.tconstruct.common.data.tags.FluidTagProvider;
import slimeknights.tconstruct.common.data.tags.ItemTagProvider;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.fluids.fluids.SlimeFluid;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.plugin.DietPlugin;
import slimeknights.tconstruct.plugin.ImmersiveEngineeringPlugin;
import slimeknights.tconstruct.plugin.jsonthings.JsonThingsPlugin;
import slimeknights.tconstruct.shared.TinkerClient;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;

@Mod(value="tconstruct")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TConstruct {
    public static final String MOD_ID = "tconstruct";
    public static final Logger LOG = LogManager.getLogger((String)"tconstruct");
    public static final Random RANDOM = new Random();
    public static TConstruct instance;

    public TConstruct() {
        instance = this;
        Config.init();
        MinecraftForge.EVENT_BUS.addListener(TConstruct::missingMappings);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)new TinkerCommons());
        bus.register((Object)new TinkerMaterials());
        bus.register((Object)new TinkerFluids());
        bus.register((Object)new TinkerGadgets());
        bus.register((Object)new TinkerWorld());
        bus.register((Object)new TinkerStructures());
        bus.register((Object)new TinkerTables());
        bus.register((Object)new TinkerModifiers());
        bus.register((Object)new TinkerToolParts());
        bus.register((Object)new TinkerTools());
        bus.register((Object)new TinkerSmeltery());
        TinkerModule.initRegisters();
        TinkerNetwork.setup();
        TinkerTags.init();
        TinkerBookIDs.registerCommandSuggestion();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TinkerClient::onConstruct);
        ModList modList = ModList.get();
        if (modList.isLoaded("immersiveengineering")) {
            bus.register((Object)new ImmersiveEngineeringPlugin());
        }
        if (modList.isLoaded("jsonthings")) {
            JsonThingsPlugin.onConstruct();
        }
        if (modList.isLoaded("diet")) {
            DietPlugin.onConstruct();
        }
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        MaterialRegistry.init();
        ToolDefinitionLoader.init();
        StationSlotLayoutLoader.init();
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        DataGenerator datagenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        BlockTagProvider blockTags = new BlockTagProvider(datagenerator, existingFileHelper);
        datagenerator.m_236039_(server, (DataProvider)blockTags);
        datagenerator.m_236039_(server, (DataProvider)new ItemTagProvider(datagenerator, blockTags, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new FluidTagProvider(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new EntityTypeTagProvider(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new BlockEntityTypeTagProvider(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new BiomeTagProvider(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new EnchantmentTagProvider(datagenerator, existingFileHelper));
        datagenerator.m_236039_(server, (DataProvider)new TConstructLootTableProvider(datagenerator));
        datagenerator.m_236039_(server, (DataProvider)new AdvancementsProvider(datagenerator));
        datagenerator.m_236039_(server, (DataProvider)new GlobalLootModifiersProvider(datagenerator));
    }

    @Nullable
    private static Block missingBlock(String name) {
        return switch (name) {
            case "blood_slime" -> Blocks.f_50374_;
            case "blood_congealed_slime" -> (CongealedSlimeBlock)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.EARTH));
            case "blood_fluid" -> TinkerFluids.earthSlime.getBlock();
            default -> null;
        };
    }

    private static void missingMappings(MissingMappingsEvent event) {
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registry.f_122901_, name -> {
            if (name.equals("blood_fluid")) {
                return TinkerFluids.earthSlime.getBlock();
            }
            return TConstruct.missingBlock(name);
        });
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registry.f_122904_, name -> switch (name) {
            case "earth_slime_sling" -> (ModifiableItem)TinkerTools.earthStaff.get();
            case "sky_slime_sling" -> (ModifiableItem)TinkerTools.skyStaff.get();
            case "ichor_slime_sling" -> (ModifiableItem)TinkerTools.ichorStaff.get();
            case "ender_slime_sling" -> (ModifiableItem)TinkerTools.enderStaff.get();
            case "earth_slime_spawn_egg" -> Items.f_42644_;
            case "bloodbone" -> (Item)TinkerMaterials.venombone.get();
            case "blood_slime_ball" -> Items.f_42518_;
            case "blood_bucket" -> TinkerFluids.earthSlime.m_5456_();
            case "blood_bottle" -> (Item)TinkerFluids.slimeBottle.get((Enum)SlimeType.EARTH);
            case "ichor_bottle" -> (Item)TinkerFluids.slimeBottle.get((Enum)SlimeType.ICHOR);
            default -> {
                Block block = TConstruct.missingBlock(name);
                if (block == null) {
                    yield null;
                }
                yield block.m_5456_();
            }
        });
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registry.f_122899_, name -> switch (name) {
            case "blood" -> (SlimeFluid)TinkerFluids.earthSlime.getStill();
            case "flowing_blood" -> (SlimeFluid)TinkerFluids.earthSlime.getFlowing();
            default -> null;
        });
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)MOD_ID, (ResourceKey)Registry.f_122903_, name -> name.equals("earth_slime") ? EntityType.f_20526_ : null);
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static <T> TinkerDataCapability.TinkerDataKey<T> createKey(String name) {
        return TinkerDataCapability.TinkerDataKey.of(TConstruct.getResource(name));
    }

    public static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of(TConstruct.getResource(name), constructor);
    }

    public static String resourceString(String res) {
        return String.format("%s:%s", MOD_ID, res);
    }

    public static String prefix(String name) {
        return "tconstruct." + name.toLowerCase(Locale.US);
    }

    public static String makeDescriptionId(String type, String name) {
        return type + ".tconstruct." + name;
    }

    public static String makeTranslationKey(String base, String name) {
        return Util.makeTranslationKey(base, TConstruct.getResource(name));
    }

    public static MutableComponent makeTranslation(String base, String name) {
        return Component.m_237115_((String)TConstruct.makeTranslationKey(base, name));
    }

    public static MutableComponent makeTranslation(String base, String name, Object ... arguments) {
        return Component.m_237110_((String)TConstruct.makeTranslationKey(base, name), (Object[])arguments);
    }

    public static void sealTinkersClass(Object self, String base, String solution) {
        String name = self.getClass().getName();
        if (!name.startsWith("slimeknights.tconstruct.")) {
            throw new IllegalStateException(base + " being extended from invalid package " + name + ". " + solution);
        }
    }
}

