/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.MoveTowardsVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.goals.DefendVillageGuardGoal;
import tallestegg.guardvillagers.entities.goals.RangedCrossbowAttackPassiveGoal;

public class GuardEntity
extends CreatureEntity
implements ICrossbowUser,
IRangedAttackMob {
    private static final DataParameter<Integer> GUARD_VARIANT = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_CHARGING_STATE = EntityDataManager.func_187226_a(GuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal(this, 1.0, true){

        public void func_75251_c() {
            super.func_75251_c();
            GuardEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            GuardEntity.this.func_213395_q(true);
        }
    };
    private final RangedCrossbowAttackPassiveGoal<GuardEntity> aiCrossBowAttack = new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f);

    public GuardEntity(EntityType<? extends GuardEntity> type, World world) {
        super(type, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_110163_bv();
        this.setCombatTask();
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        int type = GuardEntity.getRandomTypeForBiome((IWorld)this.field_70170_p, this.func_180425_c());
        if (spawnDataIn instanceof GuardData) {
            type = ((GuardData)spawnDataIn).variantData;
            spawnDataIn = new GuardData(type);
        }
        this.setCombatTask();
        this.setGuardVariant(type);
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiCrossBowAttack);
            ItemStack itemstack2 = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_222114_py));
            if (itemstack2.func_77973_b() instanceof CrossbowItem) {
                this.field_70715_bh.func_75776_a(4, this.aiCrossBowAttack);
            } else {
                this.field_70715_bh.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setGuardVariant(compound.func_74762_e("Type"));
        this.setCombatTask();
    }

    public void func_70636_d() {
        if (this.field_70173_aa % 100 == 0 && GuardConfig.GuardHealthRegen) {
            this.func_70691_i(2.0f);
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GUARD_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DATA_CHARGING_STATE, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_CHARGING_STATE);
    }

    public void func_213671_a(boolean p_213671_1_) {
        this.field_70180_af.func_187227_b(DATA_CHARGING_STATE, (Object)p_213671_1_);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int i = this.field_70146_Z.nextInt(2);
        if (i == 0) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151040_l));
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222114_py));
        }
        this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 50.0f;
    }

    public int getGuardVariant() {
        return (Integer)this.field_70180_af.func_187225_a(GUARD_VARIANT);
    }

    public void setGuardVariant(int typeId) {
        this.field_70180_af.func_187227_b(GUARD_VARIANT, (Object)typeId);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsVillageGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new DefendVillageGuardGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 0.6, false, 4, () -> false));
        if (GuardConfig.GuardSurrender) {
            this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal<RavagerEntity>((CreatureEntity)this, RavagerEntity.class, 12.0f, 0.5, 0.5){

                public boolean func_75250_a() {
                    return ((GuardEntity)this.field_75380_a).func_110143_aJ() <= 15.0f && super.func_75250_a();
                }
            });
        }
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        if (GuardConfig.GuardSurrender) {
            this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal<RavagerEntity>((MobEntity)this, RavagerEntity.class, true){

                public boolean func_75250_a() {
                    return ((GuardEntity)this.field_75299_d).func_110143_aJ() >= 15.0f && super.func_75250_a();
                }
            });
        }
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WitchEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IllusionerEntity.class, true));
        if (!GuardConfig.GuardSurrender) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, RavagerEntity.class, true));
        }
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{GuardEntity.class, IronGolemEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VexEntity.class, true));
        if (GuardConfig.AttackAllMobs) {
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, mob -> mob instanceof IMob));
        }
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        Hand hand = ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_222114_py);
        ItemStack itemstack = this.func_184586_b(hand);
        if (this.func_213382_a(Items.field_222114_py)) {
            CrossbowItem.func_220014_a((World)this.field_70170_p, (LivingEntity)this, (Hand)hand, (ItemStack)itemstack, (float)1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        }
        this.field_70708_bq = 0;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public void func_213670_a(LivingEntity target, ItemStack p_213670_2_, IProjectile projectile, float projectileAngle) {
        Entity entity = (Entity)projectile;
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226281_cx_() - this.func_226281_cx_();
        double d2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        double d3 = target.func_226283_e_(0.3333333333333333) - entity.func_226278_cu_() + d2 * (double)0.2f;
        Vector3f vector3f = this.func_213673_a(new Vec3d(d0, d3, d1), projectileAngle);
        projectile.func_70186_c((double)vector3f.func_195899_a(), (double)vector3f.func_195900_b(), (double)vector3f.func_195902_c(), 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_219616_bH, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
    }

    private Vector3f func_213673_a(Vec3d p_213673_1_, float p_213673_2_) {
        Vec3d vec3d = p_213673_1_.func_72432_b();
        Vec3d vec3d1 = vec3d.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
        if (vec3d1.func_189985_c() <= 1.0E-7) {
            vec3d1 = vec3d.func_72431_c(this.func_213286_i(1.0f));
        }
        Quaternion quaternion = new Quaternion(new Vector3f(vec3d1), 90.0f, true);
        Vector3f vector3f = new Vector3f(vec3d);
        vector3f.func_214905_a(quaternion);
        Quaternion quaternion1 = new Quaternion(vector3f, p_213673_2_, true);
        Vector3f vector3f1 = new Vector3f(vec3d);
        vector3f1.func_214905_a(quaternion1);
        return vector3f1;
    }

    public ItemStack func_213356_f(ItemStack shootable) {
        if (shootable.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)shootable.func_77973_b()).func_220006_d();
            ItemStack itemstack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Type", this.getGuardVariant());
    }

    public static int getRandomTypeForBiome(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        if (biome.func_201856_r() == Biome.Category.PLAINS) {
            return 0;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 1;
        }
        if (biome.func_201856_r() == Biome.Category.SAVANNA) {
            return 2;
        }
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            return 3;
        }
        if (biome.func_201856_r() == Biome.Category.JUNGLE) {
            return 4;
        }
        if (biome.func_201856_r() == Biome.Category.TAIGA) {
            return 5;
        }
        if (biome.func_201856_r() == Biome.Category.ICY) {
            return 6;
        }
        return 0;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() instanceof CreatureEntity) {
            CreatureEntity creatureentity = (CreatureEntity)this.func_184187_bx();
            this.field_70761_aq = creatureentity.field_70761_aq;
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof SwordItem || heldStack.func_77973_b() instanceof CrossbowItem && player.func_225608_bj_()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, heldStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
        }
        return true;
    }

    public static String getNameByType(int id) {
        switch (id) {
            case 0: {
                return "plains";
            }
            case 1: {
                return "desert";
            }
            case 2: {
                return "savanna";
            }
            case 3: {
                return "swamp";
            }
            case 4: {
                return "jungle";
            }
            case 5: {
                return "taiga";
            }
            case 6: {
                return "snow";
            }
        }
        return "";
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    public static class GuardData
    implements ILivingEntityData {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }
}

