/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.configuration;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="guardvillagers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuardConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static boolean GuardModel;
    public static boolean RaidAnimals;
    public static boolean WitchesVillager;
    public static boolean IllusionerRaids;
    public static boolean AttackAllMobs;
    public static boolean GuardSurrender;
    public static boolean GuardHealthRegen;

    public static void bakeConfig() {
        GuardModel = (Boolean)GuardConfig.COMMON.GuardModel.get();
        RaidAnimals = (Boolean)GuardConfig.COMMON.RaidAnimals.get();
        WitchesVillager = (Boolean)GuardConfig.COMMON.WitchesVillager.get();
        IllusionerRaids = (Boolean)GuardConfig.COMMON.IllusionerRaids.get();
        AttackAllMobs = (Boolean)GuardConfig.COMMON.AttackAllMobs.get();
        GuardSurrender = (Boolean)GuardConfig.COMMON.GuardSurrender.get();
        GuardHealthRegen = (Boolean)GuardConfig.COMMON.GuardHealthRegen.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            GuardConfig.bakeConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue GuardModel;
        public final ForgeConfigSpec.BooleanValue RaidAnimals;
        public final ForgeConfigSpec.BooleanValue WitchesVillager;
        public final ForgeConfigSpec.BooleanValue IllusionerRaids;
        public final ForgeConfigSpec.BooleanValue AttackAllMobs;
        public final ForgeConfigSpec.BooleanValue GuardSurrender;
        public final ForgeConfigSpec.BooleanValue GuardHealthRegen;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            this.GuardModel = builder.comment("Switch Guard Model To Vanilla Style?, (textures not completed yet)").translation("guardvillagers.config.GuardModel").define("Vanilla Styled Model?", false);
            this.RaidAnimals = builder.comment("Illagers In Raids Attack Animals?").translation("guardvillagers.config.RaidAnimals").define("Illagers In Raids Attack Animals?", false);
            this.WitchesVillager = builder.comment("Witches Attack Villagers?").translation("guardvillagers.config.WitchesVillager").define("Witches Attack Villagers?", true);
            this.IllusionerRaids = builder.comment("Illusioners in Raids?").translation("guardvillagers.config.IllusionerRaids").define("Illusioners in Raids?", true);
            this.AttackAllMobs = builder.comment("Guards Attack All Mobs?").translation("guardvillagers.config.AttackAllMobs").define("Guards Attack All Mobs?", false);
            this.GuardSurrender = builder.comment("This option makes guards run from ravagers when low on health").translation("guardvillagers.config.GuardSurrender").define("Make Guards Run From Ravagers When Low On Health?", true);
            this.GuardHealthRegen = builder.comment("This makes the guard villagers have a slow natural health regeneration.").translation("guardvillagers.config.GuardHealthRegen").define("Have Natural Health Regen For The Guards? ", false);
        }
    }
}

